#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1  Red
#property indicator_color2  Blue
#property indicator_color3  Aqua
#property indicator_color4  Magenta
#property indicator_width1  2
#property indicator_width2  2

//
//
//
//
//

extern string TimeFrame       = "Current time frame";
extern int    FractalPeriod   = 25;
extern int    PriceHigh       = PRICE_HIGH;
extern int    PriceLow        = PRICE_LOW;

extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = true;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = false;
extern bool   alertsNotify    = true;
extern bool   alertsEmail     = true;
extern string soundFile       = "alert2.wav"; 

extern int    BOArrowSize     = 5;
extern bool   ArrowsOnFirstBar= true;


double v1[];
double v2[];
double arrowUp[];
double arrowDn[];
double trend[];

//
//
//
//
//

string indicatorFileName;
int    timeFrame;
bool   returnBars;
bool   calculateValue;

//
//
//
//
//
  
int init()
{
   IndicatorBuffers(5);
   SetIndexBuffer(0,v1);      SetIndexStyle(0,DRAW_ARROW);               SetIndexArrow(0,159); SetIndexLabel(0,"Resistance");
   SetIndexBuffer(1,v2);      SetIndexStyle(1,DRAW_ARROW);               SetIndexArrow(1,159); SetIndexLabel(1,"Support");
   SetIndexBuffer(2,arrowUp); SetIndexStyle(2,DRAW_ARROW,0,BOArrowSize); SetIndexArrow(2,241);
   SetIndexBuffer(3,arrowDn); SetIndexStyle(3,DRAW_ARROW,0,BOArrowSize); SetIndexArrow(3,242);
   SetIndexBuffer(4,trend);
   
    //
    //
    //
    //
    //
      
      indicatorFileName = WindowExpertName();
      calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
      returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
      timeFrame         = stringToTimeFrame(TimeFrame);
      
    //
    //
    //
    //
    //
      
    IndicatorShortName(timeFrameToString(timeFrame)+"  Fractals - adjustable price breakout");
return(0);
}

//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
            int limit = MathMin(Bars-counted_bars,Bars-1);
            if (returnBars) { v1[0] = limit+1; return(0); }
            
   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame==Period())
   { 
     int half = FractalPeriod/2;    
     for(int i=limit; i>=0; i--) 
     {
        bool   found     = true;
         double compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i);
         for (int k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i+k)> compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i-k)>=compareTo) { found=false; break; }
            }
         if (found) v1[i] = iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i);
         else       v1[i] = v1[i+1];

         //
         //
         //
         //
         //
      
         found     = true;
         compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceLow,i);
         for (k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i+k)< compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i-k)<=compareTo) { found=false; break; }
            }
         if (found) v2[i] = iMA(NULL,0,1,0,MODE_SMA,PriceLow,i);  
         else       v2[i] = v2[i+1];
         
         //
         //
         //
         //
         //
         
         trend[i] = trend[i+1];
         if (Close[i]>v1[i]) trend[i] = 1;
         if (Close[i]<v2[i]) trend[i] =-1;
         
         //
         //
         //
         //
         //
      
         arrowUp[i] = EMPTY_VALUE;
         arrowDn[i] = EMPTY_VALUE;
         if (trend[i]!= trend[i+1])
         if (trend[i] == 1)
               arrowUp[i] = Low[i]  - iATR(NULL,0,20,i)/2;
         else  arrowDn[i] = High[i] + iATR(NULL,0,20,i)/2;
     }
   manageAlerts();   
   return(0);
   }
  
   //
   //
   //
   //
   //
   
   int shift = -1; if (ArrowsOnFirstBar) shift=1;
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit;i>=0; i--)
   {
       int y = iBarShift(NULL,timeFrame,Time[i]);
       int x = iBarShift(NULL,timeFrame,Time[i+shift]);  
          v1[i]       = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FractalPeriod,PriceHigh,PriceLow,0,y);
          v2[i]       = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FractalPeriod,PriceHigh,PriceLow,1,y);
          trend[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FractalPeriod,PriceHigh,PriceLow,4,y);
        if (x!=y)
      {
          arrowUp[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FractalPeriod,PriceHigh,PriceLow,2,y);
          arrowDn[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FractalPeriod,PriceHigh,PriceLow,3,y);
      }
      else
      {
          arrowUp[i] = EMPTY_VALUE;
          arrowDn[i] = EMPTY_VALUE;
      }
   }
manageAlerts();
return(0);
}
 
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}

//
//
//
//
//

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}

//
//
//
//
//

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] == 1) doAlert(whichBar,"buy");
         if (trend[whichBar] ==-1) doAlert(whichBar,"sell");
      }         
   }
}   

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," - ",timeFrameToString(timeFrame)+" Fractals - adjustable price breakout ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Fractals - adjustable price breakout "),message);
          if (alertsSound)   PlaySound(soundFile);
   }
}

